/*
 * Decompiled with CFR 0.152.
 */
package fuzs.armorstatues.api.world.inventory;

import com.mojang.datafixers.util.Pair;
import fuzs.armorstatues.api.world.inventory.ArmorStandHolder;
import fuzs.armorstatues.api.world.inventory.data.ArmorStandStyleOption;
import fuzs.armorstatues.core.ModServices;
import fuzs.armorstatues.mixin.accessor.ArmorStandAccessor;
import fuzs.armorstatues.mixin.accessor.SimpleContainerAccessor;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.CompoundContainer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ArmorStandMenu
extends AbstractContainerMenu
implements ArmorStandHolder {
    public static final ResourceLocation EMPTY_ARMOR_SLOT_SWORD = new ResourceLocation("armorstatues", "item/empty_armor_slot_sword");
    static final ResourceLocation[] TEXTURE_EMPTY_SLOTS = new ResourceLocation[]{InventoryMenu.f_39696_, InventoryMenu.f_39695_, InventoryMenu.f_39694_, InventoryMenu.f_39693_, InventoryMenu.f_39697_, EMPTY_ARMOR_SLOT_SWORD};
    public static final EquipmentSlot[] SLOT_IDS = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET, EquipmentSlot.MAINHAND, EquipmentSlot.OFFHAND};
    private final Container armorStandInventory;
    private final ArmorStand armorStand;

    public static ArmorStandMenu create(MenuType<?> menuType, int containerId, Inventory inventory, FriendlyByteBuf buf) {
        ArmorStand entity = (ArmorStand)inventory.f_35978_.f_19853_.m_6815_(buf.readInt());
        if (entity != null) {
            entity.m_20331_(buf.readBoolean());
            ((ArmorStandAccessor)entity).setDisabledSlots(buf.readInt());
            return ArmorStandMenu.create(menuType, containerId, inventory, entity);
        }
        return new ArmorStandMenu(menuType, containerId, inventory, (Container)new SimpleContainer(6), null);
    }

    public static ArmorStandMenu create(MenuType<?> menuType, int containerId, Inventory inventory, ArmorStand armorStand) {
        NonNullList<ItemStack> armorItems = ((ArmorStandAccessor)armorStand).getArmorItems();
        NonNullList<ItemStack> handItems = ((ArmorStandAccessor)armorStand).getHandItems();
        SimpleContainer handItemsContainer = ArmorStandMenu.simpleContainer(handItems);
        handItemsContainer.m_19164_(container -> {
            if (container.m_216874_(stack -> !stack.m_41619_())) {
                ArmorStandStyleOption.setArmorStandData(armorStand, true, 4);
            }
        });
        CompoundContainer container2 = new CompoundContainer((Container)ArmorStandMenu.simpleContainer(armorItems), (Container)handItemsContainer);
        return new ArmorStandMenu(menuType, containerId, inventory, (Container)container2, armorStand);
    }

    private static SimpleContainer simpleContainer(NonNullList<ItemStack> items) {
        SimpleContainer container = new SimpleContainer(items.size());
        ((SimpleContainerAccessor)container).setItems(items);
        return container;
    }

    private ArmorStandMenu(MenuType<?> menuType, int containerId, final Inventory inventory, Container container, final ArmorStand armorStand) {
        super(menuType, containerId);
        EquipmentSlot equipmentslot;
        this.armorStandInventory = container;
        this.armorStand = armorStand;
        for (int k = 0; k < 4; ++k) {
            equipmentslot = SLOT_IDS[k];
            this.m_38897_(new Slot(this.armorStandInventory, 3 - k, 58, 20 + k * 18){

                public void m_5852_(ItemStack stack) {
                    ItemStack oldStack = this.m_7993_();
                    super.m_5852_(stack);
                    armorStand.m_238392_(equipmentslot, oldStack, stack);
                }

                public int m_6641_() {
                    return 1;
                }

                public boolean m_5857_(ItemStack stack) {
                    if (!inventory.f_35978_.m_7500_()) {
                        if (ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 0)) {
                            return false;
                        }
                        if (ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 16) && !this.m_6657_()) {
                            return false;
                        }
                    }
                    if (equipmentslot == EquipmentSlot.HEAD) {
                        return true;
                    }
                    return ModServices.ABSTRACTIONS.canEquip(stack, equipmentslot, (Entity)inventory.f_35978_);
                }

                public boolean m_8010_(Player player) {
                    if (!inventory.f_35978_.m_7500_() && ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 8)) {
                        return false;
                    }
                    return super.m_8010_(player);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)TEXTURE_EMPTY_SLOTS[equipmentslot.m_20749_()]);
                }
            });
        }
        for (int i = 0; i < 2; ++i) {
            equipmentslot = SLOT_IDS[4 + i];
            final ResourceLocation slotTexture = TEXTURE_EMPTY_SLOTS[5 - i];
            this.m_38897_(new Slot(this.armorStandInventory, 4 + i, 136, 56 + i * 18){

                public boolean m_5857_(ItemStack stack) {
                    if (!inventory.f_35978_.m_7500_()) {
                        if (ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 0)) {
                            return false;
                        }
                        if (ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 16) && !this.m_6657_()) {
                            return false;
                        }
                    }
                    return super.m_5857_(stack);
                }

                public boolean m_8010_(Player player) {
                    if (!inventory.f_35978_.m_7500_() && ArmorStandMenu.isSlotDisabled(armorStand, equipmentslot, 8)) {
                        return false;
                    }
                    return super.m_8010_(player);
                }

                public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                    return Pair.of((Object)InventoryMenu.f_39692_, (Object)slotTexture);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.m_38897_(new Slot((Container)inventory, j1 + (l + 1) * 9, 25 + j1 * 18, 96 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.m_38897_(new Slot((Container)inventory, i1, 25 + i1 * 18, 154));
        }
    }

    public static boolean isSlotDisabled(ArmorStand armorStand, EquipmentSlot slot, int offset) {
        return (((ArmorStandAccessor)armorStand).getDisabledSlots() & 1 << slot.m_20750_() + offset) != 0;
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            int i;
            ItemStack itemStack2 = slot.m_7993_();
            itemStack = itemStack2.m_41777_();
            EquipmentSlot equipmentSlot = Mob.m_147233_((ItemStack)itemStack);
            if (index >= 0 && index < 6 ? !this.m_38903_(itemStack2, 6, 42, false) : (equipmentSlot.m_20743_() == EquipmentSlot.Type.ARMOR && !((Slot)this.f_38839_.get(3 - equipmentSlot.m_20749_())).m_6657_() ? !this.m_38903_(itemStack2, i = 3 - equipmentSlot.m_20749_(), i + 1, false) : (equipmentSlot == EquipmentSlot.OFFHAND && !((Slot)this.f_38839_.get(5)).m_6657_() ? !this.m_38903_(itemStack2, 5, 6, false) : (index >= 6 && index < 33 ? !this.m_38903_(itemStack2, 33, 42, false) : (index >= 33 && index < 42 ? !this.m_38903_(itemStack2, 6, 33, false) : !this.m_38903_(itemStack2, 6, 42, false)))))) {
                return ItemStack.f_41583_;
            }
            if (itemStack2.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemStack2.m_41613_() == itemStack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, itemStack2);
        }
        return itemStack;
    }

    public boolean m_6875_(Player player) {
        return this.armorStand != null && !this.armorStand.m_213877_();
    }

    @Override
    public ArmorStand getArmorStand() {
        return this.armorStand;
    }
}

